<?php
function frontEchoAlbum($row,$return=false)
{
	global $config;
	
	$row['name'] = htmlspecialchars($row['name']);

	$thumb='';
	if($row['thumbnail'])
	{
		$thumb = $config['imageDir'].'/s/'.$row['thumbnail'];
	}
	else $thumb = 'assets/img/empty_album_icon.jpg'; 
	
	$output='
	<div class="albumHolder">
		<div class="picRotated"></div>
		<div class="album">
			<a href="?album='.$row['id'].'" class="ajax">
				<span class="highlight" title="Browse Album"></span>
				<img src="'.$thumb.'" alt="'.$row['name'].'" width="160" height="120" title="Browse Album" />
				<span class="albumCnt" title="Contains '.$row['cnt'].' image'.($row['cnt']==1?'':'s').'">'.$row['cnt'].'</span>
			</a>
		</div>
		<div class="albumTitle" title="'.$row['name'].'">'.$row['name'].'</div>
		<div class="clear"></div>
	</div>';
	
	if($return) return $output;
	else echo $output;
}

function frontEchoPic($row,$return=false)
{
	global $config;
	
	$row['title'] = htmlspecialchars($row['title']);
	$row['description'] = htmlspecialchars($row['description']);
	
	$output='
	<div class="picHolder">
		<div class="pic">
			<a href="?pic='.$row['id'].'" class="zoomPic">
			<span class="highlight" title="Click To View"></span>
			<img src="'.$config['imageDir'].'/s/'.$row['filename'].'" alt="'.$row['title'].'" width="160" height="120" title="Click To View" />
			</a>
		</div>
		<div class="picTitle">'.$row['title'].'</div>
		<div class="data">
			<div class="id">'.$row['id'].'</div>
		</div>
		<div class="clear"></div>
	</div>';
	
	if($return) return $output;
	else echo $output;
}

function frontEchoPagination($currentPage,$totalPages,$formatString,$return=false)
{
	$formatString = str_replace('&','&amp;',$formatString);
	
	$output='<span class="label">Page:</span>
	<div class="paginationList"><span id="currentPage">'.$currentPage.'</span>
		<div id="paginationListExpand">
			<ul class="paginationUL">';
	
	for($i=0;$i<$totalPages;$i++)
	{
		$output.='<li '.($i+1==$currentPage?'class="activeLI"':'').'>'.($i+1).'<div class="data">'.sprintf($formatString,$i+1).'</div></li>';
	}
	
	$output.='
			</ul>
		</div>
	</div>
	
	<a id="button-previousPage" href="'.sprintf($formatString,($currentPage==1)?$currentPage:$currentPage-1).'" class="button gray arrow '.($currentPage==1?'inactive':'').' ajax" title="Previous Page"><img src="assets/img/arrow_left.png" alt="Previous" /><span class="right"></span></a>
	<a id="button-nextPage" href="'.sprintf($formatString,($currentPage>=$totalPages)?$currentPage:$currentPage+1).'" class="button gray arrow '.($currentPage>=$totalPages?'inactive':'').' ajax" title="Next Page"><img src="assets/img/arrow_right.png" alt="Next" /><span class="right"></span></a>
	';
	
	if($totalPages<2) $output='';
	
	if($return) return $output;
	else echo $output;
}
?>