var lsButtons = {
	'goto-step2'	: function(){
		progress(2);
		navigateTo('step-2');
	},
	'goto-step3'	: function(){
		var preloader = $('#step2-preloader');
		if(preloader.hasClass('active')) return false;
		preloader.addClass('active');
		
		ajax(2,$('#step2-form').serialize(),function(msg){
			if(!msg) return false;

			if(msg.status==1)
			{
				progress(3);
				navigateTo('step-3');
			}
			else
			{
				showError(msg.txt);
			}
			preloader.removeClass('active');
		});
	},
	'goto-step4'	: function(){
		var preloader = $('#step3-preloader');
		if(preloader.hasClass('active')) return false;
		preloader.addClass('active');
		
		ajax(3,$('#step3-form').serialize(),function(msg){
			if(!msg) return false;

			if(msg.status==1)
			{
				progress(4);
				navigateTo('step-4');
			}
			else
			{
				showError(msg.txt);
			}
			preloader.removeClass('active');
		});

	},
	'backto-step1'	: function(){
		progress(1);
		navigateTo('step-1');
	},
	'backto-step2'	: function(){
		progress(2);
		navigateTo('step-2');
	},
	'backto-step3'	: function(){
		progress(3);
		navigateTo('step-3');
	},
	
	'finish' : function(){
		var preloader = $('#step4-preloader');
		if(preloader.hasClass('active')) return false;
		preloader.addClass('active');
		
		ajax(4,{},function(msg){
			if(!msg) return false;

			if(msg.status==1)
			{
				if(msg.txt)
				{
					showSuccess(msg.txt);
				}
				navigateTo('step-5');
			}
			else
			{
				showError(msg.txt);
			}
			preloader.removeClass('active');
		});
	}
};


$(function(){

	$('#main').fadeIn('slow');

	$('.lsButton').click(function(e){
		if(lsButtons[this.id])
		{
			lsButtons[this.id]();
		}
		e.preventDefault();
	});
	
	$('#topMessage').click(function(){
		hideTop();
	});
});

function ajax(step,data,func){
	$.get('assets/ajax/install.php?step='+step,data,function(msg){func(msg);},'json');
}

function progress(p){
	$('#progress').attr('title','Step '+p+' of 4').html(p+'/4');
}

function navigateTo(str){
	$('.step:visible').fadeOut('slow',function(){
		$('#'+str).fadeIn('slow');
	});
	
	if($('#topMessage').hasClass('error'))
		hideTop();
}

function showError(str){
	$('#topMessage').addClass('error').html(str).stop(true,true).slideDown();
	window.scrollTo(0,0);
}

function showSuccess(str){
	$('#topMessage').removeClass('error').html(str).stop(true,true).slideDown();
}

function hideTop(){
	$('#topMessage').stop(true,true).fadeOut();
}
