<?php


require "../assets/includes/compatibility.php";
require "../assets/includes/functions.php";
require "../assets/includes/config.php";
require "../assets/includes/session.php";

if(file_exists("../assets/includes/generated/config.php"))
{
	header("Location: ../");
	exit;
}

$gdVersion = (int)gdVersion();

$dirs = array('/uploads/b/','/uploads/m/','/uploads/s/','/assets/includes/generated/');

if($gdVersion<2)
{
	$errorString='This gallery requires version 2 or above of the GD library for image resizing. You need to install it before continuing with this wizard.';
}

else
{
	$errors = array();
	foreach($dirs as $k=>$d)
	{
		$d = '..'.$d;
		if(!is_writable($d))
		{
			if(!@chmod($d,0777))
				$errors[] = $dirs[$k];
		}
	}
	
	if(count($errors)) 
	{
		$errorString.=  join('<br />',$errors).
		'<br /><br />The folder'.(count($errors)==1?'':'s').' above '.(count($errors)==1?'is':'are').' not writable. You need to chmod '.(count($errors)==1?'it':'them').' to 777 via FTP or SSH before you can continue with the installation.';
	}
}

if($errorString) $errorString = '<div class="errorArea">'.$errorString.'</div>';

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?php echo $config['scriptName']?> | Installation</title>

<link rel="stylesheet" type="text/css" href="../admin/admin.css" />
<link rel="stylesheet" type="text/css" href="assets/css/install.css" />

</head>

<body>

<div id="topMessage" class="error"></div>

<noscript><p id="hideMe">You need to have JavaScript enabled at this point.</p></noscript>

<div id="main">
	<h1><?php echo $config['scriptName']?><i>Installation</i></h1>
    
    <div id="progress" class="rounded10" title="Step 1 of 4">1/4</div>
    
    <div id="steps">
    
    	<div id="step-1" class="step" style="display:block;">
          <div class="container rounded10">
	            <p class="heading">You are about to install your new SlickGallery!</p>
				<p>This wizard will guide you through a qick <i>4 step</i> installation in which you will be required to fill in your <i>MySQL connection details</i>, so be sure to have them handy.</p>
                <p>You can cancel this installer at any time.</p>
                <?php echo $errorString?>
            </div>
            
            <?php if(!$errorString):?>
            	<a href="" id="goto-step2" class="next lsButton">Next</a>
            <?php endif;?>
            
      </div>
    
    	<div id="step-2" class="step">
       
	       <div class="formContainer rounded10">
           
				<p class="heading">MySQL Login Details</p>			    
           
           		<div class="hr"></div>
           
                <form id="step2-form" action="" method="post">
                    <fieldset>
                    	<div class="formRow">
	                        <label>Host</label><input type="text" name="hostname" id="hostname" />
                        </div>
                        
                        <div class="formRow">
	                        <label>Username</label><input type="text" name="dbusername" id="dbusername" />
                        </div>
                        
                        <div class="formRow">
                        	<label>Password</label><input type="password" id="dbpass" name="dbpass" />
                        </div>
                        
                        <div class="formRow">
	                        <label>DB Name</label><input type="text" name="dbname" id="dbname" />
                        </div>
                        
                        <div class="formRow">
	                        <label>Table Prefix</label><input type="text" name="tprefix" id="tprefix" value="slickgallery_" />
                        </div>
                    </fieldset>
                </form>
                
                <div class="hr"></div>
                
                <p class="footer">The "Table Prefix" setting allows you to install more than one gallery in the same database. If you don't want to use this feature, leave the table prefix as is.<br /><br />Fill in your connection details and hit "Next". Your data will be validated and a test connection will be established.</p>
                
            </div>

			<div class="backNextGroup">
                <a href="" id="backto-step1" class="back lsButton">Back</a>
                <a href="" id="goto-step3" class="next lsButton">Next</a>
                <div id="step2-preloader" class="rotate"></div>
            </div>
        </div>

    	<div id="step-3" class="step">
       
	       <div class="formContainer rounded10">
           
				<p class="heading">Admin Account Details</p>			    
           
           		<div class="hr"></div>
           
                <form id="step3-form" action="" method="post">
                    <fieldset>
                    	<div class="formRow">
	                        <label>Username</label><input type="text" name="username" id="username" />
                        </div>
                        
                        <div class="formRow">
	                        <label>Password</label><input type="password" name="password" id="password" />
                        </div>
                        
                        <div class="formRow">
	                        <label>Email</label><input type="text" name="email" id="email" />
                        </div>
                        
                    </fieldset>
                </form>
                
                <div class="hr"></div>
                
                <p class="footer">You will need the username and password above to login to your Gallery Admin Panel. Also be sure to enter a valid email.</p>
                
            </div>

			<div class="backNextGroup">
                <a href="" id="backto-step2" class="back lsButton">Back</a>
                <a href="" id="goto-step4" class="next lsButton">Next</a>
                <div id="step3-preloader" class="rotate"></div>
            </div>
        </div>


		<div id="step-4" class="step">
          <div class="container rounded10">
	            <p class="heading">Finishing the installation</p>
				<p>Hitting the "Finish" button below, will create all the needed tables in the database, your admin account, and will insert a sample album to the gallery.</p>
                <p>After this you will be able to enjoy a new way of browsing and sharing your photos.</p>
            </div>
            
            <div class="backNextGroup">
                <a href="" id="backto-step3" class="back lsButton">Back</a>
	          	<a href="" id="finish" class="finish lsButton">Finish</a>
                <div id="step4-preloader" class="rotate"></div>
			</div>
            
	      </div>

		<div id="step-5" class="step">
          <div class="container rounded10">
	            <p class="heading">Done!</p>
				<p>Your new gallery is ready to go! It is located here:<br /><a href="<?php echo $config['scriptURL']?>" target="_blank"><?php echo $config['scriptURL']?></a></p>
                <p>For access to your Admin Interface, go to this address:<br /><a href="<?php echo $config['scriptURL']?>admin/" target="_blank"><?php echo $config['scriptURL']?>admin/</a></p>
                <p>Have a great time with your new SlickGallery!</p>
            </div>
            
	      </div>

    </div>
    
</div>

<script type="text/javascript" src="../assets/scripts/jquery-1.4.min.js"></script>
<script type="text/javascript" src="assets/js/install.js"></script>
</body>
</html>