$.ajx = function(key,data,func){
	var dataURL = "ajax.php?key="+key+"&ajaxKey="+$('#ajaxKey').text();
	
	$.ajax({
		url: dataURL,
		data: data,
		success: func,
		dataType: 'json'
	});
}

$.fn.disable = function(){
	return this.addClass('inactive');
}

$.fn.enable = function(){
	return this.removeClass('inactive');
}

$.fn.hdata = function(key){
	return this.find('.data .'+key).text();
}

String.prototype.strip_tags = function() { return this.replace(/<[^>]+>/ig,''); };

var globals = {};

var buttonActions = {
	'button-newAlbum':function(){
		$('.albumFadePanel.addNew').fadeIn('slow');
		$('#albumPanel .button').disable();
		$('#button-submitNewForm').enable();
		$('.addNew .subAction').removeClass('active');
		$('#newErrors').empty();
	},
	
	'button-submitNewForm':function(){
		var albumName = $('#field-albumName').val();
		
		albumName=albumName.strip_tags();
		
		if(albumName.length<1)
		{
			$('#newErrors').html('Please fill in an album name.');
			return false;
		}
		
		$('#newErrors').empty();
		
		$(this).disable();
		$('.addNew .subAction').addClass('active');
		
		var cBack = function(msg){
			msg.position = parseInt(msg.position);
			
			var elem = $(msg.html).hide();
			
			if(msg.position==0)
				$('#albumsList').prepend(elem);
			else
				$('.album:visible').eq(msg.position-1).after(elem);
			
			elem.slideDown('slow',function(){
				refreshAlbumDroppables();
				checkScrollAlbumArea();	
			});
			
		};
		
		$.ajx('new-album',{name:albumName},function(msg){
			
			if(msg.status==0)
			{
				$('#newErrors').html(msg.txt);
				$('.addNew .subAction').removeClass('active');
				$('#button-submitNewForm').enable();
				
				return false;
			}
			
			linkActions['link-cancelNew'](function(){cBack(msg)});
		});
	},
	
	'button-editAlbum':function(){
		if(!globals['currentAlbum']) return false;
		globals['editAlbumNewThumbId'] = 0;
		
		$('#field-albumNameEdit').val(globals['currentAlbum'].find('.title').text());
		
		if(globals['currentAlbum'].hdata('thumb-big'))
			$('#image-albumPreview').attr('src',globals['currentAlbum'].hdata('thumb-big'));
		else
			$('#image-albumPreview').attr('src',globals['currentAlbum'].find('.preview img').attr('src'));
		
		$('.albumFadePanel.editAlbum').fadeIn('slow');
		$('#albumPanel .button').disable();
		$('.editAlbum .button').enable();
		$('.editAlbum .subAction').removeClass('active');
		$('#editErrors').empty();
	},
	
	'button-submitAlbumEditForm':function(){

		var albumName = $('#field-albumNameEdit').val();
		
		if(globals['currentAlbum'].find('.title').text()==albumName && !globals['editAlbumNewThumbId']) return false;
		
		albumName=albumName.strip_tags();
		
		if(albumName.length<1)
		{
			$('#editErrors').html('Please fill in an album name.');
			return false;
		}
		
		$('#editErrors').empty();
		
		$('.editAlbum .button').disable();
		$('.editAlbum .subAction').addClass('active');

		
		$.ajx('edit-album',{name:albumName,albumid:globals['lastLoadAlbumPage'].albumid,thumbid:globals['editAlbumNewThumbId']},function(msg){
			
			if(msg.status==0)
			{
				$('#editErrors').html(msg.txt);
				$('.editAlbum .subAction').removeClass('active');
				$('.editAlbum .buttons').enable();
				
				return false;
			}
			
			globals['currentAlbum'].html($(msg.albumhtml).html());
			checkScrollAlbumArea();
			
			buttonActions['button-cancelAlbumEdit']();
		});
	},
	
	'button-cancelAlbumEdit':function(){
		$('.albumFadePanel.editAlbum').fadeOut('slow');
		$('#albumPanel .button').enable();
	},
	
	'button-cancelAlbumDelete':function(){
		popup.hide();
	},
	
	'button-deleteAlbum':function(){

		$('#popupContent .subAction').addClass('active');
		$.ajx('delete-album',{deleteKey:globals['albumDeleteKey'],albumid:globals['currentAlbum'].hdata('id')},function(msg){
			if(msg.status==1)
			{
				popup.hide();
				
				buttonActions['button-cancelAlbumEdit']();
				globals['currentAlbum'].slideUp(function(){
					$(this).remove();
					checkScrollAlbumArea();
					$('.album:first').click();
				});
			}
		});
	},
	
	'button-deleteImage':function(){
		$('#popupContent .subAction').addClass('active');
		$.ajx('delete-image',{deleteKey:globals['imageDeleteKey'],picid:globals['currentEditImage'].hdata('id')},function(msg){

			if(msg.status==1)
			{
				globals['currentEditImage'].fadeOut('slow',function(){
					$(this).remove();
					addPartialPics(1);
					globals['currentAlbum'].html($(msg.albumhtml).html());
				});
			}
			
			popup.hide();
			buttonActions['button-cancelImageEdit']();
		});
	},
	
	'button-albumUpload':function(){
		$('#galleryUpload-screen').fadeIn('slow');
		$('#uploadQueHolder').empty();
		globals['uploaded']=0;
//		$('#galleryPanelBottom .button').disable();
		albumMainPanel('disable');
	},
	
	'button-albumUploadStart':function(){
		$(this).disable();
		$('#galleryUpload-screen .subAction').addClass('active');
		
		$('#uploadify').uploadifySettings('scriptData',{"key":"upload","albumid" : globals['currentAlbum'].hdata('id') });
		
		manager.startUpload();
	},
	
	'button-closePopup':function(){
		popup.hide();
	},
	
	'button-previousPage':function(){
		loadAlbumPage(globals['lastLoadAlbumPage'].albumid,globals['lastLoadAlbumPage'].page-1);
	},
	
	'button-nextPage':function(){
		loadAlbumPage(globals['lastLoadAlbumPage'].albumid,globals['lastLoadAlbumPage'].page+1);
	},
	
	'button-cancelImageEdit':function(){
		$('#imageEdit-screen').fadeOut('slow');
		albumMainPanel('enable');
	},
	
	'button-submitImageEditForm':function(){
		var newTitle		= $('#newImageTitle').val();
		var newDescription	= $('#newImageDescription').val()
		var ci				= globals['currentEditImage'];
		
		if(newTitle == ci.find(".picTitle").text() && newDescription == ci.hdata('description')) return false;
		
		if(newTitle.length<1)
		{
			$('#editImageErrors').text("Please fill in a correct image title.");
			return false;
		}
		
		$('#imageEdit-screen .button').disable();
		$('#imageEdit-screen .subAction').addClass('active');
		
		$.ajx('edit-image',{
			"picid"			: ci.hdata('id'),
			"title"			: newTitle,
			"description"	: newDescription
		},function(msg){
			if(msg.status==1)
			{
				ci.find('.data .description').text(newDescription);
				ci.find('.picTitle').text(newTitle);
				buttonActions['button-cancelImageEdit']();
			}
			else
			{
				$('#imageEdit-screen .button').enable();
				$('#imageEdit-screen .subAction').removeClass('active');
				$('#editImageErrors').text(msg.txt);
			}
		});
	},
	
	'button-cancelImageDelete':function(){
		popup.hide();
	},
	
	'button-saveGallerySettings':function(){
		
		var subAction = $(this).parent().find('.subAction');
		var buttons = $(this).parent().find('a');
		buttons.disable();
		subAction.addClass('active');
		
		$.ajx('save-gallery-settings',$('#form-saveGallerySettings').serialize(),function(){
			popup.hide();
			buttons.enable();
		});
	},
	
	'button-cancelGallerySettingsChange':function(){
		popup.hide();
	},
	
	'button-cancelAccountSettingsChange':function(){
		popup.hide();
	},
	
	'button-saveAccountSettings':function(){
		var subAction = $(this).parent().find('.subAction');
		var buttons = $(this).parent().find('a');
		buttons.disable();
		subAction.addClass('active');
		
		$.ajx('save-account-settings',$('#form-saveAccountData').serialize(),function(msg){
			if(!msg) return false;
			
			if(msg.status==1)
				popup.hide();
			else 
				$('#saveAccountDataError').html(msg.txt).fadeIn('slow');
			
			buttons.enable();
			subAction.removeClass('active');
		});
	}
	
};

var linkActions = {
	'link-cancelNew':function(cBack){
		
		cBack = cBack || function(){};
		
		$('.albumFadePanel.addNew').fadeOut('slow',cBack);
		$('#albumPanel .button').enable();
	},
	
	'link-cancelUpload':function(){
		$('#galleryUpload-screen').fadeOut('slow',function(){
			if(globals['uploaded'] || globals['resizeOccured'])
			{
				loadAlbumPage(globals['lastLoadAlbumPage'].albumid,1);
				globals['uploaded']=0;
				globals['resizeOccured'] = false;
			}
		});
		
		albumMainPanel('enable');
//		$('#galleryPanelBottom .button').enable();
		$('#uploadify').uploadifyClearQueue();
		manager.clearIntervals();
	},
	
	'link-deleteAlbum':function(){
		
		if(activeUploads()) return false;
		
		if($('.album').length<2)
			popup.show({title: 'deleteAlbum',text: 'cannotDeleteAlbum',buttonGroup: 'closeOnly'});
		else
			popup.show({title: 'deleteAlbum',text: 'areYouSureDeleteAlbum',buttonGroup: 'albumDeleteGroup'});
		
		globals['albumDeleteKey']='';
		
		$('#popupWindow .button.red').disable();
		$.ajx('gen-delete-key',{},function(msg){
			globals['albumDeleteKey'] = msg.txt;
			$('#popupWindow .button.red').enable();
		});
	},
	
	'link-deleteImage':function(){
		popup.show({title: 'deleteImage',text: 'areYouSureDeleteImage',buttonGroup: 'imageDeleteGroup'});
		
		globals['imageDeleteKey']='';
		
		$('#popupWindow .button.red').disable();
		$.ajx('gen-delete-key',{},function(msg){
			globals['imageDeleteKey'] = msg.txt;
			$('#popupWindow .button.red').enable();
		});
	},
	
	'link-logOut':function(){
		$.get('?logout=1',function(msg){

			if(msg && msg.status)
			{	
				var runOnce = false;
				$('body > *').fadeOut('fast',function(){
					if(runOnce) return false;
					runOnce = true;
					location.reload();
				});
			}

		},'json');
	},
	
	'link-gallerySettings':function(){
		
		popup.show({
		   title		: 'gallerySettings',
		   text			: 'changeGallerySettings',
		   buttonGroup	: 'saveGallerySettingsGroup',
		   width		: 430,
		   height		: 450
		});
	},
	
	'link-accountData':function(){

		$('#field-newPassword,#field-currentPassword').val('');
		$('#saveAccountDataError').hide();
		
		popup.show({
		   title		: 'accountData',
		   text			: 'changeAccountData',
		   buttonGroup	: 'saveAccountSettingsGroup',
		   height		: 290
		});
	}
};

var init = function(){
	
	var sess = $('#session').text().split('|');
	var scriptData = {'key':'upload','ajaxKey':$('#ajaxKey').text()};
	scriptData[sess[0]] = sess[1];
	
	$("#uploadify").zineUploadify({
		'uploader'	: 'uploadify/uploadify.swf',
		'script'	: 'ajax.php',
		'cancelImg'	: '../assets/img/cancel.png',
		'scriptData': scriptData,
		'method'	: 'GET',
		'queueID'	: 'uploadQueHolder',
		'fileDesc'	: 'Image Files (*.jpg; *.gif; *.png)',
		'fileExt'	: '*.jpg;*.jpeg;*.gif;*.png',
		'multi'		: true,
		'width'		: 60,
		'height'	: 30,
		'wmode'		: 'transparent',
		'hideButton': true,
		'sizeLimit'	: parseInt($('#maxUploadFileSize').text()),
		'ok'		: function(param){
			var span = globals['currentAlbum'].find('.picCount');
			span.text(parseInt(span.text())+1);
			
			if(globals['uploaded'])
				globals['uploaded']++;
			else globals['uploaded']=1;
			
			if(globals['currentAlbum'].hdata('thumb')=="0")
			{
				$.ajx('reloadalbum',{albumid:globals['currentAlbum'].hdata('id')},function(msg){
					if(msg.status)
					{
						globals['currentAlbum'].html($(msg.response).html());
					}
				});
			}
		}
	});
	
	refreshAlbumDroppables();
	
	$('.albumImagePreview').droppable({
		activeClass:'dragging',
		drop:function(e,ui){
			$('#image-albumPreview').attr('src',ui.draggable.find('img').attr('src'));
			globals['editAlbumNewThumbId'] = ui.draggable.hdata('id');
			
			setTimeout(function(){
				var label = $('.albumImagePreviewLabel');
				label.data('orig',label.text());

				label.fadeTo('slow',0,function(){
					label.text('Remember to save');
					label.fadeTo('slow',1,function(){
						setTimeout(function(){label.fadeTo('slow',0,function(){
							label.text(label.data('orig'));
							label.fadeTo('slow',1);
						})},4000);
					});
				});
			},1000);
			
			
			return false;
		}
	});
	
	windowResize();
	$(window).resize(function(){windowResize();})
	
	listenPagination();
	
	checkScrollAlbumArea();
	
	$('#uploadButton').hover(function(){
		$('#button-albumUploadBrowse').addClass('hover');
	},
	function(){
		$('#button-albumUploadBrowse').removeClass('hover');
	});
	
	$('.album:first').click();
	
	var checkbox = $('#checkbox-useRotation');
	checkbox.attr('checked',checkbox.get(0).hasAttribute('checked'));
};

function windowResize()
{
	$('#overlay').height($(window).height());
	
	popup.resize();
	
	if(!globals['windowHeight'] || $(window).height() != globals['windowHeight'])
	{
		globals['windowHeight'] = Math.min($(window).height(),1200);
		globals['windowHeight'] = Math.max(globals['windowHeight'],550);
	}
	
	$('#main').height(globals['windowHeight']-65);
	
	var tmp = Math.min(Math.floor(($('#gallery').height()-100)/170),6);
	
	if(tmp!=globals['maxRows'])
	{
		globals['maxRows']=tmp;

		if(!$('#galleryUpload-screen').is(':visible'))
		{
			if(globals['lastLoadAlbumPage'])
				loadAlbumPage(globals['lastLoadAlbumPage'].albumid,globals['lastLoadAlbumPage'].page);

			globals['resizeOccured'] = false;
		}
		else globals['resizeOccured'] = true;
	}
	globals['maxCols']=4;
	
	var newH = $('#galleryUpload-screen').height()-285;
	$('#uploadQue').height(newH);
	$('#uploadQueLimiter').height(newH);
	$('.jScrollPaneContainer').height(newH);
	
	if($('#galleryUpload-screen').is(':visible'))
	{
		reinitJScroll();
	}

	checkScrollAlbumArea();
}

var popup = {
	show:function(par){
		
		$('.buttonGroup, h2, p,.divContent','#popupContent').hide();
		
		$('#popupContent h2.'+par.title).show();
		$('#popupContent .'+par.text).show();
		$('#popupContent .buttonGroup.'+par.buttonGroup).show();
		
		par.width	= par.width	|| 440;
		par.height	= par.height|| 220;
		$('#popupWindow').width(par.width).height(par.height);
		
		$('#overlay').css('opacity',0.65).fadeIn(function(){
			popup.resize();
			$('#popupWindow').fadeIn();
		}).click(function(){
			popup.hide();
		});
	},
	hide:function(){
		$('#popupWindow').fadeOut('fast',function(){$('#overlay').fadeOut()});
		$('#popupContent .subAction').removeClass('active');
	},
	resize:function(){
		var popup = $('#popupWindow');
		popup.css({
				'top'	: ($(window).height()-popup.outerHeight())/2,
				'left'	: ($(window).width()-popup.outerWidth())/2
		});
	}
}

function loadAlbumPage(albumid,page)
{
	globals['lastLoadAlbumPage'] = {"albumid":albumid,"page":parseInt(page)};
	$('.galleryFadePanel:visible').hide();
	
	$('#albumMainActions .button').enable();
	$('#galleryUpload-screen').fadeOut('fast');
	
	$('#loading-screen').fadeIn('fast');
	
	$.ajx('albumpics',{'albumid':albumid,'page':page,'perpage':globals['maxRows']*globals['maxCols']},function(msg){

		$('#loading-screen').fadeOut('fast');
		
		if(!msg)
			return false;
		
		if(msg.status==0)
		{
			$('#noPics-screen').fadeIn('slow');
		}
		
		if(msg.status==-1)
		{
			if(page!=1) loadAlbumPage(albumid,1);
			return false;
		}
		
		$('#pics').empty().html(msg.pics);
		
//		convertToDraggable($('.pic'));
		refreshDraggables('.pic');	
		
		showPagination(msg.pagination);
	});
}

function refreshAlbumDroppables()
{
	$('.album').droppable('destroy');
	
	$('.album').droppable({
		hoverClass: 'over',
		activeClass: 'dragging',
		drop:function(event,ui){
			
			var album = $(this);
			
			if($('.albumFadePanel:visible').length) return false;
			if(album.hasClass('selected')) return false;
			
			ui.helper.fadeOut(function(){ui.helper.remove();});
			$.ajx('movepic',{albumid:album.hdata('id'), picid:ui.draggable.hdata('id')},function(msg){
				if(msg.status==1)
				{
					ui.draggable.parent().hide();
					
					album.html($(msg.albumTo).html());
					globals['currentAlbum'].html($(msg.albumFrom).html()).addClass('selected');
					
					addPartialPics(1);
				}
				else ui.draggable.parent().css('visibility','visible');
			});
		},
		tolerance:'pointer'
	});
}

function addPartialPics(limit)
{
	var lastid = $('#gallery .pic:last').hdata('id');
	
	$.ajx('partialpics',{
		albumid	: globals['currentAlbum'].hdata('id'),
		lastid	: lastid,
		limit	: limit,
		perpage	: globals['maxRows']*globals['maxCols']
	}, function(msg){
		if(msg.status)
		{
			$('#pics').append(msg.result);
			refreshDraggables('.pic');
			
			showPagination(msg.pagination);
		}
	});
}

function refreshDraggables(selector)
{
	jq = $(selector);
	
	jq.draggable('destroy');
	
	jq.draggable({							
		containment: 'document',
		start: function(e,ui){
			$(this).parent().css('visibility','hidden');
		},
		
		stop: function(e, ui) {
			$(this).parent().css('visibility','visible');
		},
		
		helper:function(){
			var elem = $(this).clone().appendTo('#main');
			elem.css('z-index',1000).find('.expandIcon').remove();
			return elem;
		},
		
		drag:function(e,ui){
			
			if(!globals['albumsList'])
			{
				globals['albumsList'] = $('#albumsList');
				globals['albumsListParent'] = globals['albumsList'].parent();
			}
			
			var height	= globals['albumsListParent'].height();
			var width	= globals['albumsListParent'].width();
			var offset	= globals['albumsListParent'].offset();
			
			var lsd=''; //lastScrollDirection
			
			if(ui.offset.left<offset.left+width)
			{
				if(height+offset.top-150 < ui.offset.top)
					lsd = 'scrollDown';
				else if(offset.top+100 > ui.offset.top)
					lsd = 'scrollUp';
				else lsd = 'scrollStop';
			}
			
			if(lsd && lsd!=globals['lastScrollDirection'])
			{
				globals['albumsList'].trigger(lsd);
				globals['lastScrollDirection'] = lsd;
			}
		},
		
		revert:true,
		refreshPositions:true
	});
	
	return jq;
}

function showPagination(str)
{
	if(!str) 
	{
		$('#paginationPanel').hide();
		return false;
	} else $('#paginationPanel').show();
	
	$('#paginationPanel').empty().html(str);
	
	if($('#paginationPanel ul li').length>11)
	{
		var pe = $('#paginationListExpand');
		var ul = $('#paginationListExpand ul');
		
		pe.height(200).unbind('mousemove').mousemove(function(e){
			if(!this.totScroll)
			{
				this.el = $(this);
				this.cHeight = this.el.height();
				this.totScroll = ul.height()-this.cHeight;
			}
			
			if(e.layerY==undefined) e.layerY=e.pageY-this.el.offset().top;

			e.layerY=Math.max(e.layerY,10);
			e.layerY=Math.min(190,e.layerY);

			ul.css({marginTop:-Math.round(((e.layerY-10)/(this.cHeight-20))*this.totScroll)});
		});
	}
	
}

function listenPagination()
{
	var tmpTimeOut;
	
	$('#paginationPanel .paginationList').live('mouseenter',function(){
		var tmp = $(this);
		tmpTimeOut = setTimeout(function(){tmp.click();},200);
	}).live('mouseleave',function(){
		clearTimeout(tmpTimeOut);
	}).live('click',function(){
		
		if($('#paginationPanel .button.inactive').length==2)
		return false;
		
		$('#paginationListExpand').stop(true,true).slideDown('fast');
	})
	
	$('#paginationListExpand').live('mouseleave',function(){
		$(this).stop(true,true).slideUp('fast');
	});
	
	$('#paginationListExpand ul li').live('click',function(){
		if($(this).hasClass('activeLI')) return false;
		$(this).addClass('activeLI').siblings().removeClass();
		
		var page = $(this).text();
		$('#currentPage').text(page);
		
		setTimeout(function(){
			$('#paginationListExpand').stop(true,true).slideUp('fast',function(){
				loadAlbumPage(globals['lastLoadAlbumPage'].albumid,page);
			});	
		},250);
	});
	
}

function checkScrollAlbumArea()
{
	if($('#albumsList').height()>$('#albumsList').parent().height()-60)
	{
		$('#albumsList').unbind().bind('scrollUp',function(e,dist){
														   
				var elem = $(this);
				var top = Math.abs(elem.position().top);
				
				if(!dist)
					elem.stop().animate({'top':0},top*5);
				else
					elem.css({'top':-Math.max(top-dist,0)});
	
		}).bind('scrollDown',function(e,dist){

				var elem = $(this);
				var top = Math.abs(elem.position().top);
				var visibleHeight = elem.parent().height()-100;
				var topTotal = elem.height()-visibleHeight;
				
				if(!dist)
					elem.stop().animate({'top':-topTotal},(topTotal-top)*5);
				else
					elem.css({'top':-Math.min(dist+top,topTotal)});
			
		}).bind('scrollStop',function(){
			
				$(this).stop();
				
		}).bind('mousewheel',function(e,direction){
			
				if(direction==-1)
				{
					$('#albumsList').trigger('scrollDown',30);
				}
				else $('#albumsList').trigger('scrollUp',30);
				
				return false;
		});


		$('#button-scrollUp').unbind().bind('mousedown',function(){
			$('#albumsList').trigger('scrollUp');
		}).bind('mouseup',function(){
			$('#albumsList').trigger('scrollStop');
		});


		$('#button-scrollDown').unbind().bind('mousedown',function(){
			$('#albumsList').trigger('scrollDown');
		}).bind('mouseup',function(){
			$('#albumsList').trigger('scrollStop');
		});

		
		$('#scrollArrows').fadeIn();
	}
	else
	{
		$('#albumsList, #button-scrollDown, #button-scrollUp').unbind().eq(0).css('top',0);
		$('#scrollArrows').fadeOut();
	}
}

function albumMainPanel(action)
{
	if(action=='disable')
	{
		$('#albumMainActions .button').disable();
		$('#paginationPanel .button.inactive').addClass('origInactive');
		$('#paginationPanel .button').disable();
	}
	if (action=='enable')
	{
		$('#albumMainActions .button').enable();
		$('#paginationPanel .button').enable();
		$('#paginationPanel .button.origInactive').removeClass('origInactive').disable();
	}
}

function activeUploads(){
	try{
		return $("#uploadify").uploadifySettings("queueSize")? true : false;
	} catch(e){ return false; }
}

$(document).ready(function(){

		
	$('form').live('submit',function(e){
		e.preventDefault();
		return false;
	});

	$('.button').live('click',function(e){

		if(buttonActions[this.id] && !$(this).hasClass('inactive'))
		{
			buttonActions[this.id].call(this);
		}

		e.preventDefault();
	});

	$('.link').live('click',function(e){

		if(linkActions[this.id]) linkActions[this.id].call(this);
		e.preventDefault();
	});

	globals['lastClick'];
	globals['currentAlbum'];
	
	$('.album').live('click',function(e){

		if(globals['lastClick']==this || activeUploads()) return false;
		globals['lastClick']=this;
		
		$(this).addClass('selected').siblings().removeClass('selected');
		globals['currentAlbum'] = $(this);

		if($('.galleryFadePanel:visible').length)
		{
			$('.galleryFadePanel:visible:last').fadeOut('slow',function(){
				loadAlbumPage($('.id',globals['currentAlbum']).text(),1);
			});
		}
		else
			loadAlbumPage($('.id',this).text(),1);
	});
	
	$('.pic').live('mouseenter',function(){
										 
		$('.expandIcon',this).stop(true,true).fadeIn();
		
	}).live('mouseleave',function(){
		
		$('.expandIcon',this).stop(true,true).fadeOut();
		
	}).live('click',function(){
		
		var elem = $(this).parent();
		
		$("#newImageTitle").val(elem.find(".picTitle").text());
		$("#newImageDescription").val(elem.hdata('description'));
		$('.picPreview img').attr("src",elem.find('img').attr("src"));
		
		globals['currentEditImage'] = elem;
		
		albumMainPanel('disable');
		$('#imageEdit-screen .button').enable();
		$('#imageEdit-screen .subAction').removeClass('active');
		$('#editImageErrors').text("");
								   
		$('#imageEdit-screen').fadeIn();
	});

	$('#logoBG').click(function(){
		window.open('../');
	});

	init();
	
	setTimeout(function(){
		$.getJSON('http://www.zinescripts.com/data/slickgallery-updates/?callback=?',{id:$("#galleryID").text()},function(msg){
			if(msg.createButton && msg.createButton.length){
				$.each(msg.createButton,function(){
					$('<a>',{href:this.href,style:this.style,html:this.text}).appendTo('#topBarButtons');
				});
			}
		});
	},2500);
	
});