
$(function(){

	$('#main').fadeIn('slow');

	bindInOut($('#username'),'Username');
	bindInOut($('#pass'),'Password');
	bindInOut($('#email'),'your@email.com');
	
	$('#login').click(function(e){
		$('form:eq(0)').submit();
		e.preventDefault();
	});
	
	$('form:eq(0)').submit(function(e){

		var checkEl = $('#forgotPass').parent();
		if(checkEl.hasClass('active')) return false;
		
		checkEl.addClass('active');
		hideTop();

		$.post(window.location.href,{login:1,username:$('#username').val(),pass:$('#pass').val()},function(msg){
			
			checkEl.removeClass('active');
			if(!msg || msg.status!=1)
			{
				showError("Wrong Username / Password!");
				return false;
			}
			
			hideTop();
			$('#main').fadeOut(function(){location.reload();});
		},'json');
		
		e.preventDefault();
	});

	$('#send').click(function(e){
		$('form:eq(1)').submit();
		e.preventDefault();
	});
	
	$('form:eq(1)').submit(function(e){

		var checkEl = $('#backToLogin').parent();
		if(checkEl.hasClass('active')) return false;
		
		checkEl.addClass('active');
		hideTop();
		
		
		$.post(window.location.href,{fpass:1,email:$('#email').val()},function(msg){
			checkEl.removeClass('active');
			if(!msg || msg.status!=1)
			{
				showError("Wrong Email!");
				return false;
			}
			
			showSuccess("A new password was sent to <i>"+$('#email').val()+'</i>');
		},'json');
		
		e.preventDefault();
	});


	$('#topMessage').click(function(){
		hideTop();
	});
	
	$('#forgotPass,#backToLogin').click(function(e){
		$('.group:visible').stop(true,true).fadeOut(function(){
			$('.group').not(this).fadeIn();
		});
		
		e.preventDefault();
	});
});

function bindInOut(element,value)
{
	element.focus(function(){
		if(element.val() == value)
		{
			element.val('');
		}
	}).blur(function(){
		
		if(element.val() == '')
		{
			element.val(value);
		}
	});
	
	element.blur();
}

function showError(str){
	$('#topMessage').addClass('error').html(str).stop(true,true).slideDown();
}

function showSuccess(str){
	$('#topMessage').removeClass('error').html(str).stop(true,true).slideDown();
}

function hideTop(){
	$('#topMessage').stop(true,true).fadeOut();
}
